/****************************************************************************
 **                                                                        **
 **  Raytracing scenes generator - Aron, 1998.08.12                        **
 **                                                                        **
 ****************************************************************************/

#define  MAP_TEXTURE_NTH(i)     (tbuffer + i*TEXTURE_SIZE)

// - implementacio ----------------------------------------------------------
byte sceneflags;
dword objects;
OBJECT object[10];

PLANE plane= { {  0.0, 80.0,  0.0}, 0.0 };

SPHERE sphere[5]= { {{   0.0,  0.0,   0.0},  40.0},
                    {{  90.0,  0.0,   0.0},  25.0},
                    {{ -90.0,  0.0,   0.0},  25.0},
                    {{   0.0,  0.0,  90.0},  25.0},
                    {{   0.0,  0.0, -90.0},  25.0}
                  };

CYLINDER cylinder[4]= { {{  500.0,   0.0,    0.0}, { -500.0,    0.0,    0.0}, 25.0},
                        {{    0.0, 500.0,    0.0}, {    0.0, -500.0,    0.0}, 25.0},
                        {{    0.0,   0.0,  500.0}, {    0.0,    0.0, -500.0}, 25.0},
                        {{    0.0,   0.0,  500.0}, {    0.0,    0.0, -500.0}, 200.0}
                      };

POLYGON cube[6];

CYLINDER logo[6]= { {{    0.0,   30.0,  0.0}, {  -50.0,   30.0,  0.0}, 15.0},
                    {{  -50.0,   30.0,  0.0}, {  -90.0,   10.0,  0.0}, 15.0},
                    {{  -90.0,   10.0,  0.0}, {  -90.0,  -50.0,  0.0}, 15.0},
                    {{  -90.0,  -50.0,  0.0}, {  -50.0,  -70.0,  0.0}, 15.0},
                    {{  -50.0,  -70.0,  0.0}, {    0.0,  -70.0,  0.0}, 15.0},
                    {{   30.0,   30.0,  0.0}, {   30.0,  -35.0,  0.0}, 15.0}
                 };

// - scene inicializalo rutinok ---------------------------------------------
void SetupSpheresScene(byte *tbuffer)
{ dword i;

  objects= 6;

  // sik:
  object[0].type= TPLANE;
  object[0].data= &plane;
  object[0].textureptr= MAP_TEXTURE_NTH(3);
  object[0].surfacetype= DISTANCE_SHADED | SHADOWED | REFLECTIVE;

  // gombok:
  object[1].type= TSPHERE;
  object[1].data= &sphere[0];
  object[1].textureptr= MAP_TEXTURE_NTH(1);
  object[1].surfacetype= PHONG_SHADED | SHADOWED | REFLECTIVE;

  object[2].type= TSPHERE;
  object[2].data= &sphere[1];
  object[2].textureptr= MAP_TEXTURE_NTH(0);
  object[2].surfacetype= PHONG_SHADED;

  object[3].type= TSPHERE;
  object[3].data= &sphere[2];
  object[3].textureptr= MAP_TEXTURE_NTH(0);
  object[3].surfacetype= PHONG_SHADED;

  object[4].type= TSPHERE;
  object[4].data= &sphere[3];
  object[4].textureptr= MAP_TEXTURE_NTH(1);
  object[4].surfacetype= PHONG_SHADED;

  object[5].type= TSPHERE;
  object[5].data= &sphere[4];
  object[5].textureptr= MAP_TEXTURE_NTH(1);
  object[5].surfacetype= PHONG_SHADED;

  // scene inicializalasa:
  for(i=0; i<objects; i++) InitObject[object[i].type](&object[i]);
  sceneflags= FOGGED;
}

void AnimateSpheresScene(float t)
{ float dX= 90.0*fsin(t),dZ= 90.0*fcos(t);

  // golyok forognak a kozepso korul:
  sphere[1].center.X= dX; sphere[1].center.Z= dZ;
  sphere[2].center.X= -dX; sphere[2].center.Z= -dZ;
  sphere[3].center.X= -dZ; sphere[3].center.Z= dX;
  sphere[4].center.X= dZ; sphere[4].center.Z= -dX;
}

void SetupPipeScene(byte *tbuffer)
{ dword i;

  objects= 4;

  // gomb:
  object[0].type= TSPHERE;
  object[0].data= &sphere[0];
  sphere[0].radius= 300.0;
  object[0].textureptr= MAP_TEXTURE_NTH(4);
  object[0].surfacetype= DISTANCE_SHADED | FLIPPED;

  // hengerek:
  object[1].type= TCYLINDER;
  object[1].data= &cylinder[0];
  object[1].textureptr= MAP_TEXTURE_NTH(6);
  object[1].surfacetype= PHONG_SHADED | SHADOWED;

  object[2].type= TCYLINDER;
  object[2].data= &cylinder[1];
  object[2].textureptr= MAP_TEXTURE_NTH(6);
  object[2].surfacetype= PHONG_SHADED | SHADOWED;

  object[3].type= TCYLINDER;
  object[3].data= &cylinder[2];
  object[3].textureptr= MAP_TEXTURE_NTH(6);
  object[3].surfacetype= PHONG_SHADED | SHADOWED;

  // scene inicializalasa:
  for(i=0; i<objects; i++) InitObject[object[i].type](&object[i]);
  sceneflags= 0;
}

void SetupCubeScene(byte *tbuffer)
{ dword i;

  objects= 2 + 6;

  // nagy gomb:
  object[0].type= TSPHERE;
  object[0].data= &sphere[0];
  sphere[0].radius= 200.0;
  object[0].textureptr= MAP_TEXTURE_NTH(2);
  object[0].surfacetype= DISTANCE_SHADED | FLIPPED | SHADOWED;

  // 6 poligonbol allo kocka:
  for(i=0; i<6; i++)
  { object[1 + i].type= TPOLYGON;
    object[1 + i].data= &cube[i];
    object[1 + i].textureptr= MAP_TEXTURE_NTH(3);
    object[1 + i].surfacetype= PHONG_SHADED;
  }

  // kis gomb kozepre:
  object[7].type= TSPHERE;
  object[7].data= &sphere[1];
  sphere[1].center.X= 0.0; sphere[1].center.Y= 0.0; sphere[1].center.Z= 0.0;
  object[7].textureptr= MAP_TEXTURE_NTH(0);
  object[7].surfacetype= PHONG_SHADED;

  // scene inicializalasa:
  for(i=0; i<objects; i++) InitObject[object[i].type](&object[i]);
  sceneflags= 0;
}

void AnimateCubeScene(float t)
{ dword i;
  float sine= fsin(t),cosine= fcos(t);

  // forgo kocka:
#define  X00   -50.0
#define  Y00    50.0
#define  Z00    50.0
#define  X01   -50.0
#define  Y01   -50.0
#define  Z01    50.0
#define  X02    50.0
#define  Y02    50.0
#define  Z02    50.0

  cube[0].A.X=  X00; cube[0].A.Y=  Y00*cosine - Z00*sine; cube[0].A.Z=  Y00*sine   + Z00*cosine;
  cube[0].B.X=  X01; cube[0].B.Y=  Y01*cosine - Z01*sine; cube[0].B.Z=  Y01*sine   + Z01*cosine;
  cube[0].C.X=  X02; cube[0].C.Y=  Y02*cosine - Z02*sine; cube[0].C.Z=  Y02*sine   + Z02*cosine;

#define  X10   -50.0
#define  Y10    50.0
#define  Z10   -50.0
#define  X11   -50.0
#define  Y11   -50.0
#define  Z11   -50.0
#define  X12    50.0
#define  Y12    50.0
#define  Z12   -50.0

  cube[1].A.X=  X10; cube[1].A.Y=  Y10*cosine - Z10*sine; cube[1].A.Z=  Y10*sine   + Z10*cosine;
  cube[1].B.X=  X11; cube[1].B.Y=  Y11*cosine - Z11*sine; cube[1].B.Z=  Y11*sine   + Z11*cosine;
  cube[1].C.X=  X12; cube[1].C.Y=  Y12*cosine - Z12*sine; cube[1].C.Z=  Y12*sine   + Z12*cosine;

#define  X20   -50.0
#define  Y20    50.0
#define  Z20    50.0
#define  X21   -50.0
#define  Y21    50.0
#define  Z21   -50.0
#define  X22   -50.0
#define  Y22   -50.0
#define  Z22    50.0

  cube[2].A.X=  X20; cube[2].A.Y=  Y20*cosine - Z20*sine; cube[2].A.Z=  Y20*sine   + Z20*cosine;
  cube[2].B.X=  X21; cube[2].B.Y=  Y21*cosine - Z21*sine; cube[2].B.Z=  Y21*sine   + Z21*cosine;
  cube[2].C.X=  X22; cube[2].C.Y=  Y22*cosine - Z22*sine; cube[2].C.Z=  Y22*sine   + Z22*cosine;

#define  X30    50.0
#define  Y30    50.0
#define  Z30    50.0
#define  X31   -50.0
#define  Y31    50.0
#define  Z31    50.0
#define  X32    50.0
#define  Y32    50.0
#define  Z32   -50.0

  cube[3].A.X=  X30; cube[3].A.Y=  Y30*cosine - Z30*sine; cube[3].A.Z=  Y30*sine   + Z30*cosine;
  cube[3].B.X=  X31; cube[3].B.Y=  Y31*cosine - Z31*sine; cube[3].B.Z=  Y31*sine   + Z31*cosine;
  cube[3].C.X=  X32; cube[3].C.Y=  Y32*cosine - Z32*sine; cube[3].C.Z=  Y32*sine   + Z32*cosine;

#define  X40    50.0
#define  Y40    50.0
#define  Z40   -50.0
#define  X41    50.0
#define  Y41    50.0
#define  Z41    50.0
#define  X42    50.0
#define  Y42   -50.0
#define  Z42   -50.0

  cube[4].A.X=  X40; cube[4].A.Y=  Y40*cosine - Z40*sine; cube[4].A.Z=  Y40*sine   + Z40*cosine;
  cube[4].B.X=  X41; cube[4].B.Y=  Y41*cosine - Z41*sine; cube[4].B.Z=  Y41*sine   + Z41*cosine;
  cube[4].C.X=  X42; cube[4].C.Y=  Y42*cosine - Z42*sine; cube[4].C.Z=  Y42*sine   + Z42*cosine;

#define  X50    50.0
#define  Y50   -50.0
#define  Z50   -50.0
#define  X51    50.0
#define  Y51   -50.0
#define  Z51    50.0
#define  X52   -50.0
#define  Y52   -50.0
#define  Z52   -50.0

  cube[5].A.X=  X50; cube[5].A.Y=  Y50*cosine - Z50*sine; cube[5].A.Z=  Y50*sine   + Z50*cosine;
  cube[5].B.X=  X51; cube[5].B.Y=  Y51*cosine - Z51*sine; cube[5].B.Z=  Y51*sine   + Z51*cosine;
  cube[5].C.X=  X52; cube[5].C.Y=  Y52*cosine - Z52*sine; cube[5].C.Z=  Y52*sine   + Z52*cosine;

  // belso gomb sugara valtozik:
  sphere[1].radius= 60.0 + 30.0*fsin(2.0*t);

  // ujrainicializalas:
  for(i=1; i<1 + 6; i++) InitObject[TPOLYGON](&object[i]);
}

void SetupMirrorBallScene(byte *tbuffer)
{ dword i;

  objects= 4;

  // henger:
  object[0].type= TCYLINDER;
  object[0].data= &cylinder[3];
  cylinder[3].A.Z= -300.0;
  cylinder[3].B.Z= 300.0;
  object[0].textureptr= MAP_TEXTURE_NTH(1);
  object[0].surfacetype= DISTANCE_SHADED | SHADOWED | FLIPPED;

  // ketoldali lezaro gombok:
  object[1].type= TSPHERE;
  object[1].data= &sphere[1];
  object[1].textureptr= MAP_TEXTURE_NTH(1);
  sphere[1].center.X= 0.0; sphere[1].center.Y= 0.0; sphere[1].center.Z= 350.0;
  sphere[1].radius= 200.0;
  object[1].surfacetype= PHONG_SHADED | SHADOWED;

  object[2].type= TSPHERE;
  object[2].data= &sphere[2];
  object[2].textureptr= MAP_TEXTURE_NTH(1);
  sphere[2].center.X= 0.0; sphere[2].center.Y= 0.0; sphere[2].center.Z= -350.0;
  sphere[2].radius= 200.0;
  object[2].surfacetype= PHONG_SHADED | SHADOWED;

  // uveggomb:
  object[3].type= TSPHERE;
  object[3].data= &sphere[0];
  sphere[0].radius= 80.0;
  object[3].textureptr= MAP_TEXTURE_NTH(0);
  object[3].surfacetype= PHONG_SHADED | REFRACTIVE;

  // scene inicializalasa:
  for(i=0; i<objects; i++) InitObject[object[i].type](&object[i]);
  sceneflags= 0;
}

void AnimateMirrorBallScene(float t)
{ // uveggolyo ide-oda gurul a cso falan:
  sphere[0].center.Y= 100.0*fsin(t);
}

void SetupColumnsScene(byte *tbuffer)
{ dword i;

  // negy oszlop kozott egy refraktiv gomb:
  objects= 6;

  // egy sik:
  object[0].type= TPLANE;
  object[0].data= &plane;
  object[0].textureptr= MAP_TEXTURE_NTH(1);
  object[0].surfacetype= DISTANCE_SHADED | SHADOWED;

  // refraktiv golyo kozepen:
  object[1].type= TSPHERE;
  sphere[0].center.X= 0.0; sphere[0].center.Y=30; sphere[0].center.Z= 0.0;
  sphere[0].radius= 80.0;
  object[1].data= &sphere[0];
  object[1].textureptr= MAP_TEXTURE_NTH(5);
  object[1].surfacetype= PHONG_SHADED | REFRACTIVE;

  // oszlopok:
  object[2].type= TCYLINDER;
  cylinder[0].A.X= 100.0; cylinder[0].A.Y= 0.0; cylinder[0].A.Z= 100.0;
  cylinder[0].B.X= 80.0; cylinder[0].B.Y= 150.0; cylinder[0].B.Z= 80.0;
  cylinder[0].radius= 30.0;
  object[2].data= &cylinder[0];
  object[2].textureptr= MAP_TEXTURE_NTH(1);
  object[2].surfacetype= PHONG_SHADED;

  object[3].type= TCYLINDER;
  cylinder[1].A.X= -100.0; cylinder[1].A.Y= 0.0; cylinder[1].A.Z= 100.0;
  cylinder[1].B.X= -80.0; cylinder[1].B.Y= 150.0; cylinder[1].B.Z= 80.0;
  cylinder[1].radius= 30.0;
  object[3].data= &cylinder[1];
  object[3].textureptr= MAP_TEXTURE_NTH(2);
  object[3].surfacetype= PHONG_SHADED;

  object[4].type= TCYLINDER;
  cylinder[2].A.X= 100.0; cylinder[2].A.Y= 0.0; cylinder[2].A.Z= -100.0;
  cylinder[2].B.X= 80.0; cylinder[2].B.Y= 150.0; cylinder[2].B.Z= -80.0;
  cylinder[2].radius= 30.0;
  object[4].data= &cylinder[2];
  object[4].textureptr= MAP_TEXTURE_NTH(4);
  object[4].surfacetype= PHONG_SHADED;

  object[5].type= TCYLINDER;
  cylinder[3].A.X= -100.0; cylinder[3].A.Y= 0.0; cylinder[3].A.Z= -100.0;
  cylinder[3].B.X= -80.0; cylinder[3].B.Y= 150.0; cylinder[3].B.Z= -80.0;
  cylinder[3].radius= 30.0;
  object[5].data= &cylinder[3];
  object[5].textureptr= MAP_TEXTURE_NTH(3);
  object[5].surfacetype= PHONG_SHADED;

  // scene inicializalasa:
  for(i=0; i<objects; i++) InitObject[object[i].type](&object[i]);
}